<?php
/**
 * @package Linen
 */

global $linen; ?>
<!DOCTYPE html>
<!--[if IE 7]>    <html class="no-js IE7 IE" <?php language_attributes(); ?>> <![endif]-->
<!--[if IE 8]>    <html class="no-js IE8 IE" <?php language_attributes(); ?>> <![endif]-->
<!--[if IE 9]>    <html class="no-js IE9 IE" <?php language_attributes(); ?>> <![endif]-->
<!--[if gt IE 9]><!--> <html class="no-js" <?php language_attributes(); ?>> <!--<![endif]-->
<head>
	<title><?php wp_title( '' ); ?></title>

	<!-- Basic Meta Data -->
	<meta charset="<?php bloginfo( 'charset' ); ?>" />
	<meta name='robots' content='noindex,follow' />

	<!-- Favicon -->
	<link rel="shortcut icon" href="<?php echo get_stylesheet_directory_uri(); ?>/images/favicon.ico" />

	<!-- WordPress -->
	<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>" />
	<?php wp_head(); ?>
</head>
<body <?php body_class(); ?>>
	<div class="skip-content"><a href="#content"><?php _e( 'Skip to content', 'linen' ); ?></a></div>
	<div id="wrapper" class="clear">
		<div id="header" class="clear">
			<?php if ($linen->logoState() == 'true' ) : ?>
				<?php $upload_dir = wp_upload_dir(); ?>
				<div id="title-logo">
					<a href="<?php echo home_url( '/' ); ?>">
						<img src="<?php echo $linen->logoName(); ?>" alt="<?php if ($linen->logoAlt() !== '' ) echo $linen->logoAlt(); else echo bloginfo( 'name' ); ?>" />
					</a>
				</div>
				<?php if ($linen->logoTagline() == 'true' ) : ?>
					<div id="description">
						<h2><?php bloginfo( 'description' ); ?></h2>
					</div><!--end description-->
				<?php endif; ?>
			<?php else : ?>
				<?php if (is_home()) echo( '<h1 id="title">' ); else echo( '<div id="title">' );?><a href="<?php echo home_url(); ?>"><?php bloginfo( 'name' ); ?></a><?php if (is_home()) echo( '</h1>' ); else echo( '</div>' );?>
					<div id="description">
						<h2><?php bloginfo( 'description' ); ?></h2>
					</div><!--end description-->
			<?php endif; ?>
			<?php
				wp_nav_menu(
					array(
						'theme_location'  => 'nav-1',
						'container_id'    => 'navigation',
						'container_class' => 'clear',
						'menu_class'      => 'nav',
						'fallback_cb'     => array( &$linen, 'main_menu_fallback')
						)
					);
			?>
		</div><!--end header-->
		<?php if ( $linen->use_featured_header() ) : ?>
			<?php get_template_part( 'tmpart-featured' ); ?>
		<?php endif; ?>
		<?php if ( is_page_template( 'tm-left-sidebar.php' ) ) : ?>
			<?php get_sidebar(); ?>
		<?php endif; ?>
		<div id="content" <?php if ( ( is_page_template( 'tm-no-sidebar.php' ) ) || ( $linen->sidebarDisable() == 'true' ) ) echo ( 'class="no-sidebar"' ); ?>>